using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MelissaData;

namespace PhoneObjectSample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        //********************** DATA FILE PATHS **********************
        //  This sample sets the data file path to the installation  
        //  default.  If you installed your Melissa Data data files to 
        //  a different path, enter that location it below.            
        //  The Data Files Directory must contain the following files: 
        //  mdDomain.dat, mdEmail.ini and mdEmailConfig.ini.           
        //*************************************************************
        const string dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";
        // ********************** LICENSE STRINGS ***********************
        //    You will need a valid license string to use Email Object,   
        //   please call a sales representative at 1-800-MELISSA ext. 3 
        //        (1-800-635-4772 x3) for a license string, then          
        //            REPLACE "DEMO" with your LICENSE STRING                    

        //   SetLicenseString will also check for a valid license in  
        //   the MDEMAIL_LICENSE(Environment) variable. This allows you   
        //   to modify the license without recompiling the project
        // **************************************************************
        const string dLICENSE = "DEMO";

        //Global Phone and Phone Object Interfaces

        public MelissaData.mdGlobalPhone mdGlobalPhone;
        public MelissaData.mdPhone mdPhone;

        #region Initialize Objects
        private void Form1_Load(object sender, EventArgs e)
        {
            //Initialize Global Phone and Phone object interfaces
            mdGlobalPhone = new MelissaData.mdGlobalPhone();
            mdPhone = new MelissaData.mdPhone();

            //Set the license strings
            mdGlobalPhone.SetLicenseString(dLICENSE);
            mdPhone.SetLicenseString(dLICENSE);

            //Create a variable to check for a successful initialization
            MelissaData.mdGlobalPhone.ProgramStatus globalInitializeStatus = new MelissaData.mdGlobalPhone.ProgramStatus();
            MelissaData.mdPhone.ProgramStatus phoneInitializeStatus = new MelissaData.mdPhone.ProgramStatus();

            //Set path to data files
            globalInitializeStatus = mdGlobalPhone.Initialize(dFILELOC);
            phoneInitializeStatus = mdPhone.Initialize(dFILELOC);

            //Global Phone initialization and status reporting
            if (globalInitializeStatus == mdGlobalPhone.ProgramStatus.ErrorLicenseExpired)
            {
                label_initStatus.ForeColor = Color.Red;
                label_initStatus.Text = "License expired. Please contact a Melissa Data sales representative";
            }
            else
            {
                if (mdGlobalPhone.GetInitializeErrorString() == "No error")
                {
                    label_initStatus.ForeColor = Color.Blue;
                    label_buildnumber.ForeColor = Color.Blue;
                    label_licenseexpdate.ForeColor = Color.Blue;
                    label_initStatus.Text = mdGlobalPhone.GetInitializeErrorString();
                    label_buildnumber.Text = mdGlobalPhone.GetBuildNumber();
                    label_licenseexpdate.Text = mdGlobalPhone.GetLicenseExpirationDate();
                }
                else
                {
                    label_initStatus.ForeColor = Color.Red;
                    label_initStatus.Text = mdGlobalPhone.GetInitializeErrorString();
                }
            }

            //Phone initialization and status reporting
            if (phoneInitializeStatus == mdPhone.ProgramStatus.ErrorLicenseExpired)
            {
                label_phoneInitStatus.ForeColor = Color.Red;
                label_phoneInitStatus.Text = "License expired. Please contact a Melissa Data sales representative";
            }
            else
            {
                if (mdPhone.GetInitializeErrorString() == "No error")
                {
                    label_phoneInitStatus.ForeColor = Color.Blue;
                    label_phoneBuildNum.ForeColor = Color.Blue;
                    label_phoneLicenseExp.ForeColor = Color.Blue;

                    label_phoneInitStatus.Text = mdPhone.GetInitializeErrorString();
                    label_phoneBuildNum.Text = mdPhone.GetBuildNumber();
                    label_phoneLicenseExp.Text = mdPhone.GetLicenseExpirationDate();
                }
                else
                {
                    label_phoneInitStatus.ForeColor = Color.Red;
                    label_phoneInitStatus.Text = mdPhone.GetInitializeErrorString();
                }
            }
        }
        #endregion


        #region GlobalPhone
        private void btn_sample_Click(object sender, EventArgs e)
        {
            input_phone.Text = "+31102002999";
            input_country.Text = "NL";
            input_countryOfOrigin.Text = "USA";
        }

        private void btn_clear_Click(object sender, EventArgs e)
        {
            input_phone.Text = "";
            input_country.Text = "";
            input_countryOfOrigin.Text = "";
        }

        //Lookup the given Global Phone phone number
        private void btn_lookup_Click(object sender, EventArgs e)
        {         
            //Check to see whether a country and/or country of origin was inputted
            //   If so, then lookup the phone number with the additional inputs.
            //   Otherwise, lookup the given phone number only.
            if (input_country.Text.Length == 0)
                mdGlobalPhone.Lookup(input_phone.Text);
            else
            {
                if (input_countryOfOrigin.Text.Length == 0)
                    mdGlobalPhone.Lookup(input_phone.Text, input_country.Text);
                else
                    mdGlobalPhone.Lookup(input_phone.Text, input_country.Text, input_countryOfOrigin.Text);
            }

            //Return the output fields
            outputGlobal_results.Text = mdGlobalPhone.GetResults();
            outputGlobal_phoneNumber.Text = mdGlobalPhone.GetPhoneNumber();
            outputGlobal_NDC.Text = mdGlobalPhone.GetNationalDestinationCode();
            outputGlobal_intlPrefix.Text = mdGlobalPhone.GetInternationalPrefix();
            outputGlobal_NationPrefix.Text = mdGlobalPhone.GetNationPrefix();
            outputGlobal_locality.Text = mdGlobalPhone.GetLocality();
            outputGlobal_country.Text = mdGlobalPhone.GetCountry();
            outputGlobal_countryCode.Text = mdGlobalPhone.GetCountryCode();
            outputGlobal_DST.Text = mdGlobalPhone.GetDST();
            outputGlobal_language.Text = mdGlobalPhone.GetLanguage();
            outputGlobal_latitutde.Text = mdGlobalPhone.GetLatitude();
            outputGlobal_longitude.Text = mdGlobalPhone.GetLongitude();
            outputGlobal_adminarea.Text = mdGlobalPhone.GetAdministrativeArea();
            outputGlobal_SN.Text = mdGlobalPhone.GetSubscriberNumber();
            outputGlobal_UTC.Text = mdGlobalPhone.GetUTC();

            outputGlobal_resultsDesc.Text = returnResultsDescription(mdGlobalPhone.GetResults());

        }
        #endregion

        #region Phone Object

        //Clear the Phone Object input boxes
        private void btn_phoneClear_Click(object sender, EventArgs e)
        {
            input_phoneNum.Text = "";
            label123.Text = "";
        }

        //Enter a Phone Object sample
        private void btn_phoneSamp_Click(object sender, EventArgs e)
        {
            input_phoneNum.Text = "(949)589-5200 ext. 22";
            input_phoneZIP.Text = "92688";
        }

        //Lookup the given phone number in the Phone Object sample
        private void btm_phoneLookup_Click(object sender, EventArgs e)
        {
            //Check if a ZIP was entered. If so, then lookup the phone number with the inputted ZIP.
            //   Otherwise, lookup the phone number only.
            if (input_phoneZIP.Text.Length == 0)
                mdPhone.Lookup(input_phoneNum.Text);
            else
                mdPhone.Lookup(input_phoneNum.Text, input_phoneZIP.Text);

            //Return the output fields
            out_phoneResults.Text = mdPhone.GetResults();
            out_phoneNumber.Text = mdPhone.GetAreaCode() + mdPhone.GetPrefix() + mdPhone.GetSuffix();
            out_phoneAreaCode.Text = mdPhone.GetAreaCode();
            out_phoneNewAreaCode.Text = mdPhone.GetNewAreaCode();
            out_phonePrefix.Text = mdPhone.GetPrefix();
            out_phoneSuffix.Text = mdPhone.GetSuffix();
            out_phoneExtension.Text = mdPhone.GetExtension();
            out_phoneTimeZone.Text = mdPhone.GetTimeZone();
            out_phoneCity.Text = mdPhone.GetCity();
            out_phoneState.Text = mdPhone.GetState();
            out_phoneCountyName.Text = mdPhone.GetCountyName();
            out_phoneCountyFIPS.Text = mdPhone.GetCountyFips();
            out_phoneCountryCode.Text = mdPhone.GetCountryCode();
            out_phoneLatitude.Text = mdPhone.GetLatitude();
            out_phoneLongitude.Text = mdPhone.GetLongitude();
            out_phoneTimeZoneCode.Text = mdPhone.GetTimeZoneCode();
            out_phoneMSA.Text = mdPhone.GetMsa();
            out_phonePMSA.Text = mdPhone.GetPmsa();

            //Return the description of the results codes
            out_phoneResultsDesc.Text = returnResultsDescription(mdPhone.GetResults());

        }


        #endregion

        private string returnResultsDescription(string results)
        {
            //This method was created to easily return the descriptions of the Global Phone and Phone object results codes
            string resultsDescription = "";

            if (results.Contains("PS"))
            {
                resultsDescription += "Status Codes:";

                if (results.Contains("PS01"))
                    resultsDescription += "\r\n   PS01:   Phone number was verified to the full 10-digit level";
                if (results.Contains("PS02"))
                    resultsDescription += "\r\n   PS02:   Phone number verified area code, exchange and first digit of suffix";
                if (results.Contains("PS03"))
                    resultsDescription += "\r\n   PS03:   Corrected area code";
                if (results.Contains("PS04"))
                    resultsDescription += "\r\n   PS04:   Phone number was outside demo range";
                if (results.Contains("PS05"))
                    resultsDescription += "\r\n   PS05:   The database has expired. Contact Melissa Data.";
                if (results.Contains("PS06"))
                    resultsDescription += "\r\n   PS06:   Area code was updated";
                if (results.Contains("PS07"))
                    resultsDescription += "\r\n   PS07:   Cell phone detected";
                if (results.Contains("PS08"))
                    resultsDescription += "\r\n   PS08:   Standard landline detected";
                if (results.Contains("PS09"))
                    resultsDescription += "\r\n   PS09:   Voice Over IP (VOIP) detected";
                if (results.Contains("PS10"))
                    resultsDescription += "\r\n   PS10:   Phone number belongs to a residence";
                if (results.Contains("PS11"))
                    resultsDescription += "\r\n   PS11:   Phone number belongs to a business";
                if (results.Contains("PS12"))
                    resultsDescription += "\r\n   PS12:   Phone number belongs to a small business or home office";
                if (results.Contains("PS13"))
                    resultsDescription += "\r\n   PS13:   International toll-free number detected";
                if (results.Contains("PS14"))
                    resultsDescription += "\r\n   PS14:   Itnernational number that incurs a higher charge rate identified";
            }

            if (results.Contains("PC01"))
                resultsDescription += "\r\n\r\nChange Codes:\r\n   PC01:   Country name was changed or appended";

            if (results.Contains("PE"))
            {
                resultsDescription += "\r\nError Codes:";

                if (results.Contains("PE01"))
                    resultsDescription += "\r\n   PE01:   Bad area code entered";
                if (results.Contains("PE02"))
                    resultsDescription += "\r\n   PE02:   Phone number was not populated";
                if (results.Contains("PE03"))
                    resultsDescription += "\r\n   PE03:   Too many or too few digits entered";
                if (results.Contains("PE04"))
                    resultsDescription += "\r\n   PE04:   Multiple matches were found";
                if (results.Contains("PE05"))
                    resultsDescription += "\r\n   PE05:   Bad prefix";
                if (results.Contains("PE06"))
                    resultsDescription += "\r\n   PE05:   Bad ZIP code";
                if (results.Contains("PE08"))
                    resultsDescription += "\r\n   PE05:   No country inputted";
                if (results.Contains("PE09"))
                    resultsDescription += "\r\n   PE05:   Subscriber number out of range";
                if (results.Contains("PE10"))
                    resultsDescription += "\r\n   PE05:   Bad country inputted";

            }

            return resultsDescription;
        }


    }
}
